% Affine registration inside an optimization method. Parameters are the set
% of solutions (SwarmR), the two images (I1, I2), upper and lower bounds
% (lbound, rbound) and the distance method (dist). It minimize it.


 function V = doAffine(SwarmR, I1, I2, lbound, ubound, dist)
    persistent I1s;
    persistent I2s;
    persistent lb;
    persistent ub;
    persistent type;
    if nargin > 1 %initialize
        I1s = I1;
        I2s = I2;
        lb = lbound;
        ub = ubound;
        type = dist;
    else %actual registration
       [SwarmSize, Dim] = size(SwarmR);
       scale = [1 1 1 1 1 ];
       appD = zeros(SwarmSize,1);
       for q=1:SwarmSize
           actx = SwarmR(q,:).*(ub-lb) + lb;
           appD(q) = affine_registration_image(actx,scale,I1s,I2s,type);
       end
       V = appD; % minimize
    end
 end

